/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class PowderKegExplosion
extends Explosion {
    public PowderKegExplosion(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size, false, true);
    }

    public void func_77279_a(boolean spawnParticles) {
        this.field_77287_j.func_184148_a(null, this.field_77284_b, this.field_77285_c, this.field_77282_d, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.field_77280_f >= 2.0f) {
            this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0, new int[0]);
        }
        boolean isSmall = this.field_77281_g.size() < 128;
        ArrayList<ItemStack> allDrops = new ArrayList<ItemStack>();
        for (BlockPos blockpos : this.field_77281_g) {
            IBlockState iblockstate = this.field_77287_j.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            if (spawnParticles) {
                double d0 = (float)blockpos.func_177958_n() + this.field_77287_j.field_73012_v.nextFloat();
                double d1 = (float)blockpos.func_177956_o() + this.field_77287_j.field_73012_v.nextFloat();
                double d2 = (float)blockpos.func_177952_p() + this.field_77287_j.field_73012_v.nextFloat();
                double d3 = d0 - this.field_77284_b;
                double d4 = d1 - this.field_77285_c;
                double d5 = d2 - this.field_77282_d;
                double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                d3 /= d6;
                d4 /= d6;
                d5 /= d6;
                double d7 = 0.5 / (d6 / (double)this.field_77280_f + 0.1);
                this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + this.field_77284_b) / 2.0, (d1 + this.field_77285_c) / 2.0, (d2 + this.field_77282_d) / 2.0, d3 *= (d7 *= (double)(this.field_77287_j.field_73012_v.nextFloat() * this.field_77287_j.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
                this.field_77287_j.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
            }
            if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
            if (isSmall) {
                block.func_180653_a(this.field_77287_j, blockpos, iblockstate, 1.0f, 0);
            } else {
                List drops = block.getDrops((IBlockAccess)this.field_77287_j, blockpos, iblockstate, 0);
                float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)this.field_77287_j, (BlockPos)blockpos, (IBlockState)iblockstate, (int)0, (float)1.0f, (boolean)false, null);
                if (this.field_77287_j.field_73012_v.nextFloat() <= chance) {
                    for (ItemStack stack : drops) {
                        allDrops.add(stack);
                    }
                }
            }
            block.onBlockExploded(this.field_77287_j, blockpos, (Explosion)this);
        }
        if (!isSmall) {
            List<ItemStack> squish = this.squish(allDrops);
            for (ItemStack drop : squish) {
                int index = this.field_77287_j.field_73012_v.nextInt(this.field_77281_g.size());
                BlockPos dropPos = (BlockPos)this.field_77281_g.get(index);
                Block.func_180635_a((World)this.field_77287_j, (BlockPos)dropPos, (ItemStack)drop);
            }
        }
    }

    private List<ItemStack> squish(List<ItemStack> list) {
        NonNullList drops = NonNullList.func_191196_a();
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (ItemStack stack : list) {
            Item item = stack.func_77973_b();
            int count = stack.func_190916_E();
            int current = (Integer)map.getOrDefault((Object)item, (Object)0);
            map.put((Object)item, count + current);
        }
        for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
            int amountToDrop;
            Item item = (Item)entry.getKey();
            int stackLimit = item.getItemStackLimit(new ItemStack(item));
            for (int count = entry.getIntValue(); count > 0; count -= amountToDrop) {
                amountToDrop = Math.min(count, stackLimit);
                drops.add(new ItemStack(item, amountToDrop));
            }
        }
        return drops;
    }
}

